#ifndef LLF_RC4_H
#define LLF_RC4_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "CE2_RC4.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  LLF_RC4.h
*  State           :  %state%
*  Creation date   :  26.03.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains declarations of low level functions for RC4.
*
*  \version LLF_RC4.h#1:cinc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd. All rights reserved.
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_RC4
*
*  @param Key_ptr [in] - A pointer to the user's key buffer.
*  @param KeySizeInBytes [in] - The size of the KEY in bytes.
*  @param DataIn_ptr [in] - The pointer to the buffer of the input data to the RC4. 
*                   The pointer's value does not need to be word-aligned.
*  @param DataInSize [in] - The size of the input data.
*  @param DataOut_ptr [in/out] The pointer to the buffer of the output data from the RC4.
*                The pointer's value does not need to be word-aligned. 
*                The size of this buffer must be the same as the DataIn buffer.  
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  This function provides a RC4 function for processing data.
*
*  The function allocates an internal RC4 Context, and initializes the RC4 Context with the
*  cryptographic attributes that are needed for the RC4 cryptographic operation. Next the
*  function loads the engine with the initializing values, and then processes the data,
*  returning the processed data in the output buffer. Finally, the function frees the
*  internally allocated context.
*
*  \b 
* Algorithm:
*  -# The key-scheduling
*  -# Encryption/decryption
***************************************************************/
CE2Error_t LLF_RC4  (DxUint8_t 				      *Key_ptr, 
  DxUint32_t 				   KeySizeInBytes,
  DxUint8_t                    *DataIn_ptr,                                  
  DxUint32_t                    DataInSize,
  DxUint8_t                    *DataOut_ptr);

#ifdef __cplusplus
}
#endif

#endif
